/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/* modifications for MX kernel lib made by
 * Brice.Goglin@ens-lyon.org (LIP/INRIA/ENS-Lyon) */

#ifndef MX__SHIM_H
# define MX__SHIM_H

#include "mx_auto_config.h"
#include "myriexpress.h"

#if !defined(likely)
#if defined(__GNUC__) && !defined(__INTEL_COMPILER) && (__GNUC__ > 2 || __GNUC__ == 2 && __GNUC_MINOR__ >= 96) 
#define likely(x)	__builtin_expect(!!(x), 1)
#define unlikely(x)	__builtin_expect(!!(x), 0)
#else
#define likely(x)       (x)
#define unlikely(x)     (x)
#endif
#endif

#ifdef MX_KERNEL

#define mx_segment_t mx_ksegment_t
#define mx_segment_ptr_t mx_ksegment_ptr_t

#define MX_SEGMENT_PTR_TO_VA MX_U64_TO_KVA
#define MX_VA_TO_SEGMENT_PTR MX_KVA_TO_U64

#include "mx_klib.h"

#else /* MX_KERNEL */

#define MX_SEGMENT_PTR_TO_VA(x) (x)
#define MX_VA_TO_SEGMENT_PTR(x) (x)

#include "mx_debug.h"

#include <stdio.h>
#if !MX_OS_WINNT
#include <unistd.h>
#include <fcntl.h>
#endif
#include <stdarg.h>
#if MX_OS_UDRV
#include <malloc.h>
#endif
#include <fcntl.h>

#if MX_OS_WINNT
#define mx_snprintf _snprintf
#else
#define mx_snprintf snprintf
#endif
#define mx_sprintf sprintf
void mx_printf(const char *fmt, ...);

#include <stdlib.h>
#define mx_malloc(x) malloc(x)
#define mx_calloc(x,y) calloc(x,y)
#define mx_free(x) free(x)

#include <string.h>
#define mx_strlen(x) strlen(x)
#define mx_memcpy(x,y,z) memcpy(x,y,z)
#if MX_OS_WINNT
#define strdup _strdup
#endif

#include <errno.h>
#define mx_errno errno
#define mx_strerrno strerror(errno)

#include <stddef.h>
#define mx_offsetof offsetof

#if MX_OS_WINNT
#define mx_sched_yield() Sleep(0)
#else
#if MX_OS_SOLARIS
#define mx_sched_yield() yield()
#else
#include <sched.h>
#define mx_sched_yield() sched_yield()
#endif /* MX_OS_SOLARIS */
#endif /* MX_OS_WINNT */

#if !MX_OS_WINNT
#define mx_sleep sleep
#else
#define mx_sleep Sleep
#endif

#if !MX_OS_WINNT
#include <sys/time.h>
#include <sys/resource.h>
#endif

#if MX_OS_WINNT
MX_FUNC(int) mx_gettimeofday(struct timeval *tv, void *tz);
#include <process.h>
#define mx_getpid() _getpid()
#else
#include <sys/time.h>
#define mx_gettimeofday(x,y) gettimeofday(x,y)
#define mx_getpid() getpid()
#endif

#define mx_memcpy_from_segment(x,y,z,mctx) mx_memcpy(x,(char*)y,z)
#define mx_memcpy_to_segment(x,y,z,mctx) memcpy((char*)x,y,z)
#define mx_memcpy_between_segments(x,xmctx,y,ymctx,z) memcpy((char*)x,y,z)

#define mx_strtol strtol

#if !MX_OS_WINNT
#include <sys/utsname.h>
#endif

#if MX_OS_WINNT
#define stat _stat
#endif

#endif /* MX_KERNEL */

#endif /* MX__SHIM_H */
